/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.lib.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import org.apache.commons.lang3.SystemUtils;
import org.openas2.lib.message.MessageID;
import org.openas2.lib.util.MimeUtil;

public abstract class EDIINTMessage {
    private InternetHeaders headers;
    private MimeBodyPart data;

    public EDIINTMessage() {
    }

    public EDIINTMessage(MimeBodyPart data, String contentType) throws MessagingException {
        this.setData(data);
        this.setContentType(contentType);
    }

    public EDIINTMessage(InputStream in) throws IOException, MessagingException {
        this.setHeaders(MimeUtil.readHeaders(in));
        this.setData(MimeUtil.readMimeBodyPart(in, this.getHeaders()));
    }

    public void setContentType(String contentType) {
        this.setHeader("Content-Type", contentType);
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public void setData(MimeBodyPart data) throws MessagingException {
        this.data = data;
    }

    public MimeBodyPart getData() throws MessagingException {
        return this.data;
    }

    public void setDate(String date) {
        this.setHeader("Date", date);
    }

    public String getDate() {
        return this.getHeader("Date");
    }

    public void setDefaults() {
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, MM MMM yyyy HH:mm:ss z");
        this.setDate(sdf.format(new Date()));
        this.setMessageID(this.generateMessageID());
        this.setMimeVersion("1.0");
    }

    public void setFrom(String from) {
        this.setHeader("From", from);
    }

    public String getFrom() {
        return this.getHeader("From");
    }

    public void setHeader(String key, String value) {
        if (value == null) {
            this.getHeaders().removeHeader(key);
        } else {
            this.getHeaders().setHeader(key, value);
        }
    }

    public String getHeader(String key) {
        return this.getHeader(key, ", ");
    }

    public String getHeader(String key, String delimiter) {
        return MimeUtil.getHeader(this.getHeaders(), key, delimiter);
    }

    public void setHeaders(InternetHeaders headers) {
        this.headers = headers;
    }

    public InternetHeaders getHeaders() {
        if (this.headers == null) {
            this.headers = new InternetHeaders();
        }
        return this.headers;
    }

    public void setMessageID(String messageID) {
        this.setHeader("Message-ID", messageID);
    }

    public String getMessageID() {
        return this.getHeader("Message-ID");
    }

    public void setMimeVersion(String version) {
        this.setHeader("Mime-Version", version);
    }

    public String getMimeVersion() {
        return this.getHeader("Mime-Version");
    }

    public void setSubject(String subject) {
        this.setHeader("Subject", subject);
    }

    public String getSubject() {
        return this.getHeader("Subject");
    }

    public abstract String getSenderIDHeader();

    public String getSenderID() {
        return this.getHeader(this.getSenderIDHeader());
    }

    public abstract String getReceiverIDHeader();

    public String getReceiverID() {
        return this.getHeader(this.getReceiverIDHeader());
    }

    public String generateMessageID() {
        MessageID id = new MessageID(this.getSenderID(), this.getReceiverID());
        return id.toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Enumeration headers = this.getHeaders().getAllHeaderLines();
        while (headers.hasMoreElements()) {
            buf.append((String)headers.nextElement());
            buf.append(SystemUtils.LINE_SEPARATOR);
        }
        buf.append(SystemUtils.LINE_SEPARATOR);
        try {
            if (this.getData() != null) {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                this.getData().writeTo((OutputStream)bout);
                buf.append(new String(bout.toByteArray()));
            }
        }
        catch (Exception e) {
            buf.append("(Exception converting data to string: " + e.getMessage() + "!)");
        }
        return buf.toString();
    }
}

