/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.lib.partner;

import org.openas2.lib.message.AS1Message;
import org.openas2.lib.message.AS2Message;
import org.openas2.lib.message.EDIINTMessage;
import org.openas2.lib.partner.IPartnerStore;
import org.openas2.lib.partner.IPartnership;
import org.openas2.lib.partner.IPartnershipChooser;
import org.openas2.lib.partner.PartnerException;

public class BasicPartnershipChooser
implements IPartnershipChooser {
    private IPartnerStore partnerStore;

    public BasicPartnershipChooser(IPartnerStore partnerStore) {
        this.partnerStore = partnerStore;
    }

    @Override
    public IPartnerStore getPartnerStore() {
        return this.partnerStore;
    }

    @Override
    public IPartnership getPartnership(EDIINTMessage msg) throws PartnerException {
        IPartnerStore store = this.getPartnerStore();
        String[] aliases = store.getPartnerships();
        for (int i = 0; i < aliases.length; ++i) {
            IPartnership partnership = store.getPartnership(aliases[i]);
            if (!this.matches(partnership, msg)) continue;
            return partnership;
        }
        throw new PartnerException("Partnership not found");
    }

    protected boolean matches(IPartnership partnership, EDIINTMessage msg) {
        String senderId = msg.getSenderID();
        String receiverId = msg.getReceiverID();
        String partnerSenderId = null;
        String partnerReceiverId = null;
        if (msg instanceof AS1Message) {
            partnerSenderId = partnership.getSender().getAs1Id();
            partnerReceiverId = partnership.getReceiver().getAs1Id();
        } else if (msg instanceof AS2Message) {
            partnerSenderId = partnership.getSender().getAs2Id();
            partnerReceiverId = partnership.getReceiver().getAs2Id();
        }
        return partnerSenderId != null && partnerSenderId.equals(senderId) && partnerReceiverId != null && partnerReceiverId.equals(receiverId);
    }
}

