/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.logging;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openas2.logging.Level;
import org.openas2.logging.Logger;
import org.openas2.message.Message;

public class LogManager {
    private static LogManager defaultManager;
    private List<Logger> loggers;
    private static boolean registeredWithApache;
    ArrayList<String> requestors = new ArrayList();

    public static LogManager getLogManager() {
        if (defaultManager == null) {
            defaultManager = new LogManager();
        }
        return defaultManager;
    }

    public void setLoggers(List<Logger> listeners) {
        this.loggers = listeners;
    }

    public List<Logger> getLoggers() {
        if (this.loggers == null) {
            this.loggers = new ArrayList<Logger>();
        }
        return this.loggers;
    }

    public void addLogger(Logger logger) {
        List<Logger> loggers = this.getLoggers();
        loggers.add(logger);
    }

    public void log(Throwable e, boolean terminated) {
        Iterator<Logger> loggerIt = this.getLoggers().iterator();
        if (loggerIt.hasNext()) {
            while (loggerIt.hasNext()) {
                Logger logger = loggerIt.next();
                logger.log(e, Level.ERROR, terminated);
            }
        } else {
            e.printStackTrace();
        }
    }

    public void log(Level level, String clazzName, Object msg) {
        Iterator<Logger> loggerIt = this.getLoggers().iterator();
        if (loggerIt.hasNext()) {
            while (loggerIt.hasNext()) {
                Logger logger = loggerIt.next();
                if (msg instanceof Message) {
                    logger.log(level, clazzName + ": " + ((Message)msg).getLogMsg(), (Message)msg);
                    continue;
                }
                logger.log(level, clazzName + ": " + msg.toString(), null);
            }
        } else {
            System.out.println(level.getName() + " " + msg.toString());
        }
    }

    public void addRequestors(String inName) {
        this.requestors.add(inName);
        LogManager.setRegisteredWithApache(true);
    }

    public static void setRegisteredWithApache(boolean registedWithApache) {
        registeredWithApache = registedWithApache;
    }

    public static boolean isRegisteredWithApache() {
        return registeredWithApache;
    }

    static {
        registeredWithApache = false;
    }
}

