/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.message;

import org.openas2.message.BaseMessage;
import org.openas2.message.Message;
import org.openas2.params.CompositeParameters;
import org.openas2.params.DateParameters;
import org.openas2.params.InvalidParameterException;
import org.openas2.params.MessageParameters;
import org.openas2.params.ParameterParser;
import org.openas2.params.RandomParameters;
import org.openas2.partner.Partnership;

public class AS2Message
extends BaseMessage
implements Message {
    private static final long serialVersionUID = 1L;
    public static final String PROTOCOL_AS2 = "as2";

    @Override
    public String getProtocol() {
        return PROTOCOL_AS2;
    }

    @Override
    public String generateMessageID() throws InvalidParameterException {
        CompositeParameters params = new CompositeParameters(false).add("date", new DateParameters()).add("msg", new MessageParameters(this)).add("rand", new RandomParameters());
        String idFormat = this.getPartnership().getAttribute("messageid");
        if (idFormat == null) {
            idFormat = "OPENAS2-$date.ddMMyyyyHHmmssZ$-$rand.1234$@$msg.sender.as2_id$_$msg.receiver.as2_id$";
        }
        return ParameterParser.parse(idFormat, params);
    }

    @Override
    public boolean isRequestingMDN() {
        return this.getHeader("Disposition-Notification-To") != null || this.getHeader("Disposition-Notification-Options") != null;
    }

    @Override
    public boolean isConfiguredForMDN() {
        Partnership p = this.getPartnership();
        return p.getAttribute("as2_mdn_to") != null && p.getAttribute("as2_mdn_options") != null;
    }

    @Override
    public boolean isRequestingAsynchMDN() {
        return this.getHeader("Receipt-Delivery-Option") != null;
    }

    @Override
    public boolean isConfiguredForAsynchMDN() {
        Partnership p = this.getPartnership();
        return p.getAttribute("as2_receipt_option") != null;
    }

    public String getAsyncMDNurl() {
        return this.getHeader("Receipt-Delivery-Option");
    }
}

