/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.params;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.openas2.OpenAS2Exception;
import org.openas2.WrappedException;
import org.openas2.params.InvalidParameterException;
import org.openas2.params.ParameterParser;

public class ExceptionParameters
extends ParameterParser {
    public static final String KEY_NAME = "name";
    public static final String KEY_MESSAGE = "message";
    public static final String KEY_TRACE = "trace";
    public static final String KEY_TERMINATED = "terminated";
    private OpenAS2Exception target;
    private boolean terminated;

    public ExceptionParameters(OpenAS2Exception target, boolean terminated) {
        this.target = target;
        this.terminated = terminated;
    }

    @Override
    public void setParameter(String key, String value) throws InvalidParameterException {
        if (key == null) {
            throw new InvalidParameterException("Invalid key", this, key, value);
        }
        if (key.equals(KEY_NAME) || key.equals(KEY_MESSAGE) || key.equals(KEY_TRACE) || key.equals(KEY_TERMINATED)) {
            throw new InvalidParameterException("Parameter is read-only", this, key, value);
        }
        throw new InvalidParameterException("Invalid key", this, key, value);
    }

    @Override
    public String getParameter(String key) throws InvalidParameterException {
        Exception unwrappedTarget;
        if (key == null) {
            throw new InvalidParameterException("Invalid key", this, key, null);
        }
        OpenAS2Exception target = this.getTarget();
        if (target instanceof WrappedException) {
            unwrappedTarget = ((WrappedException)target).getSource();
            if (unwrappedTarget == null) {
                unwrappedTarget = target;
            }
        } else {
            unwrappedTarget = target;
        }
        if (key.equals(KEY_NAME)) {
            return unwrappedTarget.getClass().getName();
        }
        if (key.equals(KEY_MESSAGE)) {
            return unwrappedTarget.getMessage();
        }
        if (key.equals(KEY_TRACE)) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            target.printStackTrace(pw);
            return sw.toString();
        }
        if (key.equals(KEY_TERMINATED)) {
            if (this.isTerminated()) {
                return KEY_TERMINATED;
            }
            return "";
        }
        throw new InvalidParameterException("Invalid key", this, key, null);
    }

    public void setTarget(OpenAS2Exception target) {
        this.target = target;
    }

    public OpenAS2Exception getTarget() {
        return this.target;
    }

    public boolean isTerminated() {
        return this.terminated;
    }
}

