/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.processor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openas2.OpenAS2Exception;
import org.openas2.message.Message;
import org.openas2.processor.ActiveModule;
import org.openas2.processor.BaseProcessor;
import org.openas2.processor.NoModuleException;
import org.openas2.processor.ProcessorException;
import org.openas2.processor.ProcessorModule;

public class DefaultProcessor
extends BaseProcessor {
    private List<ProcessorModule> modules;
    private Log logger = LogFactory.getLog((String)DefaultProcessor.class.getSimpleName());

    @Override
    public List<ProcessorModule> getActiveModules() {
        ArrayList<ProcessorModule> activeMods = new ArrayList<ProcessorModule>();
        for (ProcessorModule procMod : this.getModules()) {
            if (!(procMod instanceof ActiveModule)) continue;
            activeMods.add(procMod);
        }
        return activeMods;
    }

    @Override
    public void setModules(List<ProcessorModule> modules) {
        this.modules = modules;
    }

    @Override
    public List<ProcessorModule> getModules() {
        if (this.modules == null) {
            this.modules = new ArrayList<ProcessorModule>();
        }
        return this.modules;
    }

    @Override
    public void handle(String action, Message msg, Map<Object, Object> options) throws OpenAS2Exception {
        Iterator<ProcessorModule> moduleIt = this.getModules().iterator();
        ProcessorException pex = null;
        boolean moduleFound = false;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Processor searching for module handler for action: " + action));
        }
        while (moduleIt.hasNext()) {
            ProcessorModule module = moduleIt.next();
            if (!module.canHandle(action, msg, options)) continue;
            try {
                moduleFound = true;
                module.handle(action, msg, options);
            }
            catch (OpenAS2Exception oae) {
                if (pex != null) continue;
                pex = new ProcessorException(this);
                pex.getCauses().add(oae);
            }
        }
        if (pex != null) {
            throw pex;
        }
        if (!moduleFound) {
            if ("true".equalsIgnoreCase((String)options.get("OPTIONAL_MODULE"))) {
                return;
            }
            msg.setLogMsg("No handler found for action: " + action);
            this.logger.error((Object)msg);
            throw new NoModuleException(action, msg, options);
        }
    }

    @Override
    public void startActiveModules() throws OpenAS2Exception {
        Iterator<ProcessorModule> activeIt = this.getActiveModules().iterator();
        while (activeIt.hasNext()) {
            try {
                ((ActiveModule)activeIt.next()).start();
            }
            catch (OpenAS2Exception e) {
                e.terminate();
                throw e;
            }
        }
    }

    @Override
    public void stopActiveModules() {
        Iterator<ProcessorModule> activeIt = this.getActiveModules().iterator();
        while (activeIt.hasNext()) {
            try {
                ((ActiveModule)activeIt.next()).stop();
            }
            catch (OpenAS2Exception e) {
                e.terminate();
            }
        }
    }
}

