/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.processor.msgtracking;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.h2.tools.Server;
import org.openas2.OpenAS2Exception;
import org.openas2.Session;
import org.openas2.database.H2DBHandler;
import org.openas2.logging.Log;
import org.openas2.message.Message;
import org.openas2.params.ComponentParameters;
import org.openas2.params.CompositeParameters;
import org.openas2.params.ParameterParser;
import org.openas2.processor.msgtracking.BaseMsgTrackingModule;
import org.openas2.util.DateUtil;
import org.openas2.util.Properties;

public class DbTrackingModule
extends BaseMsgTrackingModule {
    public static final String PARAM_TCP_SERVER_START = "tcp_server_start";
    public static final String PARAM_TCP_SERVER_PORT = "tcp_server_port";
    public static final String PARAM_TCP_SERVER_PWD = "tcp_server_password";
    public static final String PARAM_DB_USER = "db_user";
    public static final String PARAM_DB_PWD = "db_pwd";
    public static final String PARAM_DB_NAME = "db_name";
    public static final String PARAM_DB_DIRECTORY = "db_directory";
    public static final String PARAM_JDBC_CONNECT_STRING = "jdbc_connect_string";
    public static final String PARAM_JDBC_DRIVER = "jdbc_driver";
    public static final String PARAM_JDBC_SERVER_URL = "jdbc_server_url";
    public static final String PARAM_JDBC_PARAMS = "jdbc_extra_paramters";
    public static final String DEFAULT_TRACKING_DB_HANDLER_CLASS = "org.openas2.processor.msgtracking.DBHandler";
    public static final String PARAM_TRACKING_DB_HANDLER_CLASS = "tracking_db_handler_class";
    private String dbUser = null;
    private String dbPwd = null;
    private String dbDirectory = null;
    private String jdbcConnectString = null;
    private String configBaseDir = null;
    private boolean isRunning = false;
    private String sqlEscapeChar = "'";
    Server server = null;
    private org.apache.commons.logging.Log logger = LogFactory.getLog((String)DbTrackingModule.class.getSimpleName());

    @Override
    public void init(Session session, Map<String, String> options) throws OpenAS2Exception {
        super.init(session, options);
        CompositeParameters paramParser = this.createParser();
        this.dbUser = this.getParameter(PARAM_DB_USER, true);
        this.dbPwd = this.getParameter(PARAM_DB_PWD, true);
        this.dbDirectory = this.getParameter(PARAM_DB_DIRECTORY, true);
        this.configBaseDir = session.getBaseDirectory();
        this.jdbcConnectString = this.getParameter(PARAM_JDBC_CONNECT_STRING, true);
        this.jdbcConnectString.replace("%home%", this.configBaseDir);
        this.jdbcConnectString = ParameterParser.parse(this.jdbcConnectString, paramParser);
        this.sqlEscapeChar = Properties.getProperty("sql_escape_character", "'");
    }

    @Override
    protected String getModuleAction() {
        return "track_msg";
    }

    protected CompositeParameters createParser() {
        CompositeParameters params = new CompositeParameters(true);
        params.add("component", new ComponentParameters(this));
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void persist(Message msg, Map<String, String> map) {
        Connection conn = null;
        conn = DBConnection.getConnection(this.jdbcConnectString, this.dbUser, this.dbPwd);
        Statement s = conn.createStatement();
        String msgIdField = "MSG_ID";
        ResultSet rs = s.executeQuery("select * from msg_metadata where " + msgIdField + " = '" + map.get(msgIdField) + "'");
        ResultSetMetaData meta = rs.getMetaData();
        boolean isUpdate = rs.next();
        StringBuffer fieldStmt = new StringBuffer();
        for (int i = 0; i < meta.getColumnCount(); ++i) {
            String colName = meta.getColumnLabel(i + 1);
            if (colName.equalsIgnoreCase("ID")) continue;
            if (colName.equalsIgnoreCase("UPDATE_DT")) {
                if (!isUpdate) continue;
                this.appendField(colName, DateUtil.getSqlTimestamp(), fieldStmt, meta.getColumnType(i + 1));
                continue;
            }
            if (colName.equalsIgnoreCase("CREATE_DT")) {
                map.remove("CREATE_DT");
                continue;
            }
            if (isUpdate) {
                String dbVal;
                String mapVal = map.get(colName.toUpperCase());
                if (mapVal == null || (dbVal = rs.getString(colName)) != null && mapVal.equals(dbVal)) continue;
                this.appendField(colName, mapVal, fieldStmt, meta.getColumnType(i + 1));
                continue;
            }
            this.appendField(colName, map.get(colName.toUpperCase()), fieldStmt, meta.getColumnType(i + 1));
        }
        if (fieldStmt.length() > 0) {
            String stmt = "";
            stmt = isUpdate ? "update msg_metadata set " + fieldStmt.toString() + " where " + "MSG_ID" + " = '" + map.get(msgIdField) + "'" : "insert into msg_metadata set " + fieldStmt.toString();
            if (s.executeUpdate(stmt) <= 0) throw new OpenAS2Exception("Failed to persist tracking record to DB: " + map);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Tracking record successfully persisted to database: " + map));
            }
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("No change from existing record in DB. Tracking record not updated: " + map));
        }
        if (conn == null) return;
        try {
            DBConnection.releaseConnection(conn);
            return;
        }
        catch (OpenAS2Exception e) {
            e.printStackTrace();
            return;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return;
        catch (Exception e) {
            try {
                msg.setLogMsg("Failed to persist a tracking event: " + Log.getExceptionMsg(e) + " ::: Data map: " + map);
                this.logger.error((Object)msg, (Throwable)e);
                if (conn == null) return;
            }
            catch (Throwable throwable) {
                if (conn == null) throw throwable;
                try {
                    DBConnection.releaseConnection(conn);
                    throw throwable;
                }
                catch (OpenAS2Exception e2) {
                    e2.printStackTrace();
                    throw throwable;
                }
                catch (SQLException e3) {
                    e3.printStackTrace();
                }
                throw throwable;
            }
            try {
                DBConnection.releaseConnection(conn);
                return;
            }
            catch (OpenAS2Exception e4) {
                e4.printStackTrace();
                return;
            }
            catch (SQLException e5) {
                e5.printStackTrace();
            }
            return;
        }
    }

    private void appendField(String name, String value, StringBuffer sb, int dataType) {
        String valueEncap = "'";
        boolean requiresEncap = true;
        if (value == null) {
            requiresEncap = false;
        } else {
            switch (dataType) {
                case -8: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    requiresEncap = false;
                }
            }
        }
        if (sb.length() > 0) {
            sb.append(",");
        }
        sb.append(name).append("=");
        if (requiresEncap) {
            sb.append(valueEncap).append(value.replaceAll("'", this.sqlEscapeChar + "'")).append(valueEncap);
        } else {
            sb.append(value);
        }
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void start() throws OpenAS2Exception {
        DBConnection.start(this.jdbcConnectString, this.dbUser, this.dbPwd);
        this.isRunning = true;
        if ("true".equalsIgnoreCase(this.getParameter(PARAM_TCP_SERVER_START, "true"))) {
            String tcpPort = this.getParameter(PARAM_TCP_SERVER_PORT, "9092");
            String tcpPwd = this.getParameter(PARAM_TCP_SERVER_PWD, "OpenAS2");
            try {
                this.server = Server.createTcpServer((String[])new String[]{"-tcpPort", tcpPort, "-tcpPassword", tcpPwd, "-baseDir", this.dbDirectory, "-tcpAllowOthers"}).start();
            }
            catch (SQLException e) {
                throw new OpenAS2Exception("Failed to start TCP server", e);
            }
        }
    }

    @Override
    public void stop() {
        block4: {
            try {
                if (this.server != null) {
                    this.server.shutdown();
                } else {
                    DBConnection.stop(this.jdbcConnectString);
                }
                this.isRunning = false;
            }
            catch (Exception e) {
                if (!this.logger.isErrorEnabled()) break block4;
                this.logger.error((Object)"Failed to stop database for message tracking module.", (Throwable)e);
            }
        }
    }

    private static class DBConnection {
        private static H2DBHandler dbHandler = null;

        private DBConnection() {
        }

        public static Connection getConnection(String connectString, String userId, String pwd) throws OpenAS2Exception, SQLException {
            if (dbHandler == null) {
                throw new OpenAS2Exception("Database has not been started: " + connectString);
            }
            return dbHandler.getConnection();
        }

        public static void releaseConnection(Connection c) throws OpenAS2Exception, SQLException {
            if (dbHandler == null) {
                throw new OpenAS2Exception("Database has not been started trying to release connection");
            }
            c.close();
        }

        public static void start(String connectString, String userId, String pwd) throws OpenAS2Exception {
            if (dbHandler != null) {
                throw new OpenAS2Exception("Database was already started: " + connectString);
            }
            dbHandler = new H2DBHandler();
            dbHandler.createConnectionPool(connectString, userId, pwd);
        }

        public static void stop(String connectString) throws OpenAS2Exception, SQLException {
            if (dbHandler != null) {
                dbHandler.shutdown(connectString);
                dbHandler.destroyConnectionPool();
            }
        }
    }
}

