/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.lib;

import java.security.Key;
import java.security.cert.Certificate;
import javax.mail.internet.MimeBodyPart;
import org.apache.commons.lang3.SystemUtils;
import org.openas2.lib.EngineResults;
import org.openas2.lib.MDNException;
import org.openas2.lib.OpenAS2Exception;
import org.openas2.lib.cert.ICertificateChooser;
import org.openas2.lib.helper.EDIINTHelper;
import org.openas2.lib.helper.ICryptoHelper;
import org.openas2.lib.message.AS1Message;
import org.openas2.lib.message.AS1MessageMDN;
import org.openas2.lib.message.AS2Message;
import org.openas2.lib.message.AS2MessageMDN;
import org.openas2.lib.message.Disposition;
import org.openas2.lib.message.DispositionException;
import org.openas2.lib.message.DispositionOptions;
import org.openas2.lib.message.EDIINTMessage;
import org.openas2.lib.message.EDIINTMessageMDN;
import org.openas2.lib.message.MDNData;
import org.openas2.lib.partner.IPartnershipChooser;
import org.openas2.message.Message;
import org.openas2.partner.Partnership;

public class MDNEngine {
    private EDIINTHelper ediintHelper;
    private ICertificateChooser certificateChooser;
    private IPartnershipChooser partnershipChooser;

    public MDNEngine(EDIINTHelper ediintHelper, ICertificateChooser certificateChooser, IPartnershipChooser partnershipChooser) {
        this.ediintHelper = ediintHelper;
        this.certificateChooser = certificateChooser;
        this.partnershipChooser = partnershipChooser;
    }

    public EDIINTMessageMDN generateMDN(EDIINTMessage msg, EngineResults results) throws MDNException {
        if (msg instanceof AS1Message) {
            return this.createAS1MDN((AS1Message)msg, results);
        }
        if (msg instanceof AS2Message) {
            return this.createAS2MDN((AS2Message)msg, results);
        }
        throw new MDNException("Unsupported message type: " + msg.getClass().getName());
    }

    public EDIINTHelper getEDIINTHelper() {
        return this.ediintHelper;
    }

    public void setEDIINTHelper(EDIINTHelper ediintHelper) {
        this.ediintHelper = ediintHelper;
    }

    public ICryptoHelper getCryptoHelper() {
        return this.getEDIINTHelper().getCryptoHelper();
    }

    public ICertificateChooser getCertificateChooser() {
        return this.certificateChooser;
    }

    public void setCertificateChooser(ICertificateChooser certificateChooser) {
        this.certificateChooser = certificateChooser;
    }

    public IPartnershipChooser getPartnershipChooser() {
        return this.partnershipChooser;
    }

    public void setPartnershipChooser(IPartnershipChooser partnershipChooser) {
        this.partnershipChooser = partnershipChooser;
    }

    protected AS1MessageMDN createAS1MDN(AS1Message msg, EngineResults results) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    protected AS2MessageMDN createAS2MDN(AS2Message msg, EngineResults results) throws MDNException {
        AS2MessageMDN mdn = new AS2MessageMDN();
        mdn.setDefaults();
        mdn.setAS2From(msg.getAS2To());
        mdn.setAS2To(msg.getAS2From());
        if (results.getPartnership() != null) {
            mdn.setFrom(results.getPartnership().getSender().getContactEmail());
        } else {
            mdn.setFrom("unknown");
        }
        mdn.setSubject(this.generateMDNSubject(mdn, msg, results));
        MDNData mdnData = mdn.getMDNData();
        mdnData.setReportingUA("OpenAS2 v1.0");
        mdnData.setOriginalRecipient("rfc822; " + msg.getAS2To());
        if (results.getPartnership() != null) {
            mdnData.setFinalRecipient("rfc822; " + results.getPartnership().getReceiver().getAs2Id());
        } else {
            mdnData.setFinalRecipient("rfc822; " + msg.getAS2To());
        }
        mdnData.setOriginalMessageID(msg.getMessageID());
        mdnData.setDisposition(results.getDisposition());
        mdnData.setText(this.generateMDNText(mdn, msg, results));
        DispositionOptions dispOptions = null;
        try {
            dispOptions = new DispositionOptions(msg.getDispositionNotificationOptions());
        }
        catch (OpenAS2Exception oae) {
            throw new MDNException("Invalid disposition options", oae);
        }
        try {
            if (dispOptions.getMicAlgorithm() != null) {
                boolean includeHeaders = results.getEncryption() != 0 && results.getSignature() != 0;
                String mic = this.getCryptoHelper().calculateMIC(msg.getData(), dispOptions.getMicAlgorithm(), includeHeaders, ((Message)((Object)msg)).getPartnership().isPreventCanonicalization());
                mdnData.setReceivedContentMIC(mic);
            }
        }
        catch (Exception e) {
            throw new MDNException("Error calculating MIC", e);
        }
        try {
            if (dispOptions.getProtocol() != null) {
                ICertificateChooser certChooser = this.getCertificateChooser();
                Certificate senderCert = certChooser.getSenderCertificate(mdn);
                Key senderKey = certChooser.getSenderKey(mdn);
                Partnership p = ((Message)((Object)msg)).getPartnership();
                String contentTxfrEncoding = p.getAttribute("content_transfer_encoding");
                boolean isRemoveCmsAlgorithmProtectionAttr = "true".equalsIgnoreCase(p.getAttribute("remove_cms_algorithm_protection_attrib"));
                if (contentTxfrEncoding == null) {
                    contentTxfrEncoding = "binary";
                }
                MimeBodyPart signedData = this.getCryptoHelper().sign(mdn.getData(), senderCert, senderKey, dispOptions.getMicAlgorithm(), contentTxfrEncoding, false, isRemoveCmsAlgorithmProtectionAttr);
                mdn.setData(signedData);
                mdn.setContentType(signedData.getContentType());
            }
        }
        catch (Exception e) {
            throw new MDNException("Error signing MDN", e);
        }
        mdn.setMessageID(mdn.generateMessageID());
        return mdn;
    }

    protected String generateMDNText(EDIINTMessageMDN mdn, EDIINTMessage msg, EngineResults results) throws MDNException {
        Disposition disposition = null;
        try {
            disposition = new Disposition(mdn.getMDNData().getDisposition());
        }
        catch (DispositionException de) {
            throw new MDNException("Error generating MDN text: " + de.getMessage(), de);
        }
        StringBuffer text = new StringBuffer();
        text.append("Sender ID:    ").append(msg.getSenderID()).append(SystemUtils.LINE_SEPARATOR);
        text.append("Receiver ID:  ").append(msg.getReceiverID()).append(SystemUtils.LINE_SEPARATOR);
        String decryption = results.getStatusDescription(results.getEncryption());
        text.append("Decryption:   ").append(decryption).append(SystemUtils.LINE_SEPARATOR);
        String verification = results.getStatusDescription(results.getSignature());
        text.append("Verification: ").append(verification).append(SystemUtils.LINE_SEPARATOR);
        text.append(SystemUtils.LINE_SEPARATOR);
        if (disposition.isError()) {
            text.append("The message could not be processed: ");
        } else if (disposition.isWarning()) {
            text.append("The message was processed with a warning: ");
        } else {
            text.append("The message was processed successfully: ");
        }
        text.append(disposition);
        return text.toString();
    }

    protected String generateMDNSubject(EDIINTMessageMDN mdn, EDIINTMessage msg, EngineResults results) throws MDNException {
        StringBuffer buf = new StringBuffer();
        buf.append(msg.getSenderID()).append(" -> ").append(msg.getReceiverID());
        buf.append(" - ").append(msg.getMessageID());
        return buf.toString();
    }
}

