/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.lib.message;

import java.io.IOException;
import java.util.Enumeration;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.openas2.lib.message.EDIINTMessageMDN;
import org.openas2.lib.util.MimeUtil;

public class MDNData {
    public static final String REPORT_SUBTYPE = "report; report-type=disposition-notification";
    public static final String REPORT_TYPE = "multipart/report; report-type=disposition-notification";
    public static final String TEXT_TYPE = "text/plain";
    public static final String TEXT_CHARSET = "us-ascii";
    public static final String TEXT_ENCODING = "7bit";
    public static final String DISPOSITION_TYPE = "message/disposition-notification";
    public static final String DISPOSITION_CHARSET = "us-ascii";
    public static final String DISPOSITION_ENCODING = "7bit";
    private EDIINTMessageMDN owner;
    private boolean dirty;
    private String disposition;
    private String finalRecipient;
    private String originalMessageID;
    private String originalRecipient;
    private String receivedContentMIC;
    private String reportingUA;
    private String text;

    public MDNData(EDIINTMessageMDN owner) {
        this.owner = owner;
    }

    public void update(MimeBodyPart data) throws MessagingException {
        ContentType reportType;
        this.clearCache();
        if (data != null && (reportType = new ContentType(data.getContentType())).getBaseType().equalsIgnoreCase("multipart/report")) {
            MimeMultipart reportPart = MimeUtil.createMimeMultipart(data);
            int partCount = reportPart.getCount();
            for (int i = 0; i < partCount; ++i) {
                MimeBodyPart currentPart = (MimeBodyPart)reportPart.getBodyPart(i);
                if (currentPart.isMimeType(TEXT_TYPE)) {
                    try {
                        this.setText(currentPart.getContent().toString());
                        continue;
                    }
                    catch (IOException ioe) {
                        throw new MessagingException("Error getting text content: " + ioe.getMessage());
                    }
                }
                if (!currentPart.isMimeType(DISPOSITION_TYPE)) continue;
                try {
                    InternetHeaders disposition = new InternetHeaders(currentPart.getInputStream());
                    this.setReportingUA(disposition.getHeader("Reporting-UA", ", "));
                    this.setOriginalRecipient(disposition.getHeader("Original-Recipient", ", "));
                    this.setFinalRecipient(disposition.getHeader("Final-Recipient", ", "));
                    this.setOriginalMessageID(disposition.getHeader("Original-Message-ID", ", "));
                    this.setDisposition(disposition.getHeader("Disposition", ", "));
                    this.setReceivedContentMIC(disposition.getHeader("Received-Content-MIC", ", "));
                    continue;
                }
                catch (IOException ioe) {
                    throw new MessagingException("Error parsing disposition notification: " + ioe.getMessage());
                }
            }
        }
    }

    public MimeBodyPart getData() throws MessagingException {
        try {
            MimeMultipart reportParts = this.createReportPart();
            MimeBodyPart dispositionPart = this.createDispositionPart();
            reportParts.addBodyPart((BodyPart)dispositionPart);
            MimeBodyPart textPart = this.createTextPart();
            reportParts.addBodyPart((BodyPart)textPart);
            MimeBodyPart reportPart = MimeUtil.createMimeBodyPart(reportParts);
            return reportPart;
        }
        catch (IOException ioe) {
            throw new MessagingException("Error creating data: " + ioe.getMessage());
        }
    }

    public EDIINTMessageMDN getOwner() {
        return this.owner;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        if (dirty) {
            this.getOwner().setContentType(REPORT_TYPE);
        }
    }

    public void setDisposition(String disposition) {
        this.disposition = disposition;
        this.setDirty(true);
    }

    public String getDisposition() {
        return this.disposition;
    }

    public void setFinalRecipient(String recipient) {
        this.finalRecipient = recipient;
        this.setDirty(true);
    }

    public String getFinalRecipient() {
        return this.finalRecipient;
    }

    public void setOriginalMessageID(String messageID) {
        this.originalMessageID = messageID;
        this.setDirty(true);
    }

    public String getOriginalMessageID() {
        return this.originalMessageID;
    }

    public void setOriginalRecipient(String recipient) {
        this.originalRecipient = recipient;
        this.setDirty(true);
    }

    public String getOriginalRecipient() {
        return this.originalRecipient;
    }

    public void setReceivedContentMIC(String mic) {
        this.receivedContentMIC = mic;
        this.setDirty(true);
    }

    public String getReceivedContentMIC() {
        return this.receivedContentMIC;
    }

    public void setReportingUA(String reportingUA) {
        this.reportingUA = reportingUA;
        this.setDirty(true);
    }

    public String getReportingUA() {
        return this.reportingUA;
    }

    public void setText(String text) {
        this.text = text;
        this.setDirty(true);
    }

    public String getText() {
        return this.text;
    }

    protected void clearCache() {
        this.disposition = null;
        this.finalRecipient = null;
        this.originalMessageID = null;
        this.originalRecipient = null;
        this.receivedContentMIC = null;
        this.reportingUA = null;
        this.text = null;
    }

    protected MimeBodyPart createDispositionPart() throws IOException, MessagingException {
        MimeBodyPart dispositionPart = new MimeBodyPart();
        InternetHeaders dispValues = new InternetHeaders();
        dispValues.setHeader("Reporting-UA", this.getReportingUA());
        dispValues.setHeader("Original-Recipient", this.getOriginalRecipient());
        dispValues.setHeader("Final-Recipient", this.getFinalRecipient());
        dispValues.setHeader("Original-Message-ID", this.getOriginalMessageID());
        dispValues.setHeader("Disposition", this.getDisposition());
        dispValues.setHeader("Received-Content-MIC", this.getReceivedContentMIC());
        Enumeration dispEnum = dispValues.getAllHeaderLines();
        StringBuffer dispData = new StringBuffer();
        while (dispEnum.hasMoreElements()) {
            dispData.append((String)dispEnum.nextElement()).append("\r\n");
        }
        dispData.append("\r\n");
        String dispText = dispData.toString();
        dispositionPart.setContent((Object)dispText, DISPOSITION_TYPE);
        dispositionPart.setHeader("Content-Type", DISPOSITION_TYPE);
        return dispositionPart;
    }

    protected MimeMultipart createReportPart() throws MessagingException {
        MimeMultipart reportParts = new MimeMultipart();
        reportParts.setSubType(REPORT_SUBTYPE);
        return reportParts;
    }

    protected MimeBodyPart createTextPart() throws IOException, MessagingException {
        MimeBodyPart textPart = new MimeBodyPart();
        String text = this.getText() + "\r\n";
        textPart.setContent((Object)text, TEXT_TYPE);
        textPart.setHeader("Content-Type", TEXT_TYPE);
        return textPart;
    }
}

