/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.partner;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Partnership
implements Serializable {
    private static final long serialVersionUID = -8365608387462470629L;
    public static final String PTYPE_SENDER = "sender";
    public static final String PTYPE_RECEIVER = "receiver";
    public static final String PID_EMAIL = "email";
    public static final String PA_PROTOCOL = "protocol";
    public static final String PA_SUBJECT = "subject";
    public static final String PA_CONTENT_TRANSFER_ENCODING = "content_transfer_encoding";
    public static final String PA_REMOVE_PROTECTION_ATTRIB = "remove_cms_algorithm_protection_attrib";
    public static final String PA_SET_CONTENT_TRANSFER_ENCODING_OMBP = "set_content_transfer_encoding_on_outer_mime_bodypart";
    private Map<String, String> attributes;
    private Map<String, Object> receiverIDs;
    private Map<String, Object> senderIDs;
    private String name;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setAttribute(String id, String value) {
        this.getAttributes().put(id, value);
    }

    public String getAttribute(String id) {
        return this.getAttributes().get(id);
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        return this.attributes;
    }

    public void setReceiverID(String id, String value) {
        this.getReceiverIDs().put(id, value);
    }

    public String getReceiverID(String id) {
        return (String)this.getReceiverIDs().get(id);
    }

    public void setReceiverIDs(Map<String, Object> receiverIDs) {
        this.receiverIDs = receiverIDs;
    }

    public Map<String, Object> getReceiverIDs() {
        if (this.receiverIDs == null) {
            this.receiverIDs = new HashMap<String, Object>();
        }
        return this.receiverIDs;
    }

    public void setSenderID(String id, String value) {
        this.getSenderIDs().put(id, value);
    }

    public String getSenderID(String id) {
        return (String)this.getSenderIDs().get(id);
    }

    public void setSenderIDs(Map<String, Object> senderIDs) {
        this.senderIDs = senderIDs;
    }

    public Map<String, Object> getSenderIDs() {
        if (this.senderIDs == null) {
            this.senderIDs = new HashMap<String, Object>();
        }
        return this.senderIDs;
    }

    public boolean matches(Partnership partnership) {
        Map<String, Object> senderIDs = partnership.getSenderIDs();
        Map<String, Object> receiverIDs = partnership.getReceiverIDs();
        if (this.compareIDs(senderIDs, this.getSenderIDs())) {
            return true;
        }
        return this.compareIDs(receiverIDs, this.getReceiverIDs());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Partnership " + this.getName());
        buf.append(" Sender IDs = ").append(this.getSenderIDs());
        buf.append(" Receiver IDs = ").append(this.getReceiverIDs());
        buf.append(" Attributes = ").append(this.getAttributes());
        return buf.toString();
    }

    protected boolean compareIDs(Map<String, Object> ids, Map<String, Object> compareTo) {
        Set<Map.Entry<String, Object>> idSet = ids.entrySet();
        Iterator<Map.Entry<String, Object>> it = idSet.iterator();
        if (!it.hasNext()) {
            return false;
        }
        while (it.hasNext()) {
            Map.Entry<String, Object> currentId = it.next();
            Object currentValue = currentId.getValue();
            Object compareValue = compareTo.get(currentId.getKey());
            if (currentValue != null && compareValue == null) {
                return false;
            }
            if (currentValue == null && compareValue != null) {
                return false;
            }
            if (currentValue.equals(compareValue)) continue;
            return false;
        }
        return true;
    }

    public void copy(Partnership partnership) {
        if (partnership.getName() != null) {
            this.setName(partnership.getName());
        }
        this.getSenderIDs().putAll(partnership.getSenderIDs());
        this.getReceiverIDs().putAll(partnership.getReceiverIDs());
        this.getAttributes().putAll(partnership.getAttributes());
    }

    public boolean isAsyncMDN() {
        String receiptOptions = this.getAttribute("as2_receipt_option");
        return receiptOptions != null && receiptOptions.length() > 0;
    }

    public boolean isSetTransferEncodingOnInitialBodyPart() {
        String setTxfrEncoding = this.getAttribute("set_transfer_encoding_on_inital_body_part");
        return setTxfrEncoding == null || "true".equals(setTxfrEncoding);
    }

    public boolean isPreventCanonicalization() {
        String preventCanonicalization = this.getAttribute("prevent_canonicalization_for_mic");
        return preventCanonicalization != null && "true".equals(preventCanonicalization);
    }

    public boolean isRenameDigestToOldName() {
        String removeDash = this.getAttribute("rename_digest_to_old_name");
        return removeDash != null && "true".equals(removeDash);
    }

    public boolean isRemoveCmsAlgorithmProtectionAttr() {
        return "true".equalsIgnoreCase(this.getAttribute(PA_REMOVE_PROTECTION_ATTRIB));
    }
}

