/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.partner;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openas2.OpenAS2Exception;
import org.openas2.Session;
import org.openas2.WrappedException;
import org.openas2.params.InvalidParameterException;
import org.openas2.partner.BasePartnershipFactory;
import org.openas2.partner.Partnership;
import org.openas2.partner.RefreshablePartnershipFactory;
import org.openas2.util.FileMonitor;
import org.openas2.util.FileMonitorListener;
import org.openas2.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLPartnershipFactory
extends BasePartnershipFactory
implements RefreshablePartnershipFactory,
FileMonitorListener {
    public static final String PARAM_FILENAME = "filename";
    public static final String PARAM_INTERVAL = "interval";
    private FileMonitor fileMonitor;
    private Map<String, Object> partners;
    private Log logger = LogFactory.getLog((String)XMLPartnershipFactory.class.getSimpleName());

    public void setFileMonitor(FileMonitor fileMonitor) {
        this.fileMonitor = fileMonitor;
    }

    public FileMonitor getFileMonitor() throws InvalidParameterException {
        boolean createMonitor;
        boolean bl = createMonitor = this.fileMonitor == null && this.getParameter(PARAM_INTERVAL, false) != null;
        if (!createMonitor && this.fileMonitor != null) {
            String filename = this.fileMonitor.getFilename();
            boolean bl2 = createMonitor = filename != null && !filename.equals(this.getFilename());
        }
        if (createMonitor) {
            if (this.fileMonitor != null) {
                this.fileMonitor.stop();
            }
            int interval = this.getParameterInt(PARAM_INTERVAL, true);
            File file = new File(this.getFilename());
            this.fileMonitor = new FileMonitor(file, interval);
            this.fileMonitor.addListener(this);
        }
        return this.fileMonitor;
    }

    public void setFilename(String filename) {
        this.getParameters().put(PARAM_FILENAME, filename);
    }

    public String getFilename() throws InvalidParameterException {
        return this.getParameter(PARAM_FILENAME, true);
    }

    public void setPartners(Map<String, Object> map) {
        this.partners = map;
    }

    @Override
    public Map<String, Object> getPartners() {
        if (this.partners == null) {
            this.partners = new HashMap<String, Object>();
        }
        return this.partners;
    }

    @Override
    public void handle(FileMonitor monitor, File file, int eventID) {
        switch (eventID) {
            case 1: {
                try {
                    this.refresh();
                    this.logger.debug((Object)"- Partnerships Reloaded -");
                    break;
                }
                catch (OpenAS2Exception oae) {
                    oae.terminate();
                }
            }
        }
    }

    @Override
    public void init(Session session, Map<String, String> parameters) throws OpenAS2Exception {
        super.init(session, parameters);
        this.refresh();
    }

    @Override
    public void refresh() throws OpenAS2Exception {
        try {
            this.load(new FileInputStream(this.getFilename()));
            this.getFileMonitor();
        }
        catch (Exception e) {
            throw new WrappedException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load(InputStream in) throws ParserConfigurationException, SAXException, IOException, OpenAS2Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document document = parser.parse(in);
        Element root = document.getDocumentElement();
        NodeList rootNodes = root.getChildNodes();
        HashMap<String, Object> newPartners = new HashMap<String, Object>();
        ArrayList<Partnership> newPartnerships = new ArrayList<Partnership>();
        for (int i = 0; i < rootNodes.getLength(); ++i) {
            Node rootNode = rootNodes.item(i);
            String nodeName = rootNode.getNodeName();
            if (nodeName.equals("partner")) {
                this.loadPartner(newPartners, rootNode);
                continue;
            }
            if (!nodeName.equals("partnership")) continue;
            this.loadPartnership(newPartners, newPartnerships, rootNode);
        }
        XMLPartnershipFactory xMLPartnershipFactory = this;
        synchronized (xMLPartnershipFactory) {
            this.setPartners(newPartners);
            this.setPartnerships(newPartnerships);
        }
    }

    protected void loadAttributes(Node node, Partnership partnership) throws OpenAS2Exception {
        Map<String, String> nodes = XMLUtil.mapAttributeNodes(node.getChildNodes(), "attribute", "name", "value");
        partnership.getAttributes().putAll(nodes);
    }

    public void loadPartner(Map<String, Object> partners, Node node) throws OpenAS2Exception {
        String[] requiredAttributes = new String[]{"name"};
        Map<String, String> newPartner = XMLUtil.mapAttributes(node, requiredAttributes);
        String name = newPartner.get("name");
        if (partners.get(name) != null) {
            throw new OpenAS2Exception("Partner is defined more than once: " + name);
        }
        partners.put(name, newPartner);
    }

    protected void loadPartnerIDs(Map<String, Object> partners, String partnershipName, Node partnershipNode, String partnerType, Map<String, Object> idMap) throws OpenAS2Exception {
        Node partnerNode = XMLUtil.findChildNode(partnershipNode, partnerType);
        if (partnerNode == null) {
            throw new OpenAS2Exception("Partnership " + partnershipName + " is missing sender");
        }
        Map<String, String> partnerAttr = XMLUtil.mapAttributes(partnerNode);
        String partnerName = partnerAttr.get("name");
        if (partnerName != null) {
            Map map = (Map)partners.get(partnerName);
            Map partner = map;
            if (partner == null) {
                throw new OpenAS2Exception("Partnership " + partnershipName + " has an undefined " + partnerType + ": " + partnerName);
            }
            idMap.putAll(partner);
        }
        idMap.putAll(partnerAttr);
    }

    public void loadPartnership(Map<String, Object> partners, List<Partnership> partnerships, Node node) throws OpenAS2Exception {
        Partnership partnership = new Partnership();
        String[] requiredAttributes = new String[]{"name"};
        Map<String, String> psAttributes = XMLUtil.mapAttributes(node, requiredAttributes);
        String name = psAttributes.get("name");
        if (this.getPartnership(partnerships, name) != null) {
            throw new OpenAS2Exception("Partnership is defined more than once: " + name);
        }
        partnership.setName(name);
        this.loadPartnerIDs(partners, name, node, "sender", partnership.getSenderIDs());
        this.loadPartnerIDs(partners, name, node, "receiver", partnership.getReceiverIDs());
        this.loadAttributes(node, partnership);
        partnerships.add(partnership);
    }

    public void storePartnership() throws OpenAS2Exception {
        String fn = this.getFilename();
        DecimalFormat df = new DecimalFormat("0000000");
        long l = 0L;
        File f = null;
        while ((f = new File(fn + '.' + df.format(l))).exists()) {
            ++l;
        }
        this.logger.info((Object)("backing up " + fn + " to " + f.getName()));
        File fr = new File(fn);
        fr.renameTo(f);
        try {
            PrintWriter pw = new PrintWriter(new FileOutputStream(fn));
            Map<String, Object> partner = this.partners;
            pw.println("<partnerships>");
            for (Map.Entry<String, Object> ptrnData : partner.entrySet()) {
                HashMap partnerMap = (HashMap)ptrnData.getValue();
                pw.print("  <partner ");
                Iterator attrIt = partnerMap.entrySet().iterator();
                while (attrIt.hasNext()) {
                    Map.Entry attribute = attrIt.next();
                    pw.print((String)attribute.getKey() + "=\"" + attribute.getValue() + "\"");
                    if (!attrIt.hasNext()) continue;
                    pw.print("\n           ");
                }
                pw.println("/>");
            }
            List<Partnership> partnerShips = this.getPartnerships();
            ListIterator<Partnership> partnerLIt = partnerShips.listIterator();
            while (partnerLIt.hasNext()) {
                Partnership partnership = partnerLIt.next();
                pw.println("  <partnership name=\"" + partnership.getName() + "\">");
                pw.println("    <sender name=\"" + partnership.getSenderIDs().get("name") + "\"/>");
                pw.println("    <receiver name=\"" + partnership.getReceiverIDs().get("name") + "\"/>");
                Map<String, String> partnershipMap = partnership.getAttributes();
                for (Map.Entry<String, String> partnershipData : partnershipMap.entrySet()) {
                    pw.println("    <attribute name=\"" + partnershipData.getKey() + "\" value=\"" + partnershipData.getValue() + "\"/>");
                }
                pw.println("  </partnership>");
            }
            pw.println("</partnerships>");
            pw.flush();
            pw.close();
        }
        catch (FileNotFoundException e) {
            throw new WrappedException(e);
        }
    }
}

