/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.util;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.openas2.OpenAS2Exception;

public class DispositionOptions {
    private String micalg;
    private String micalgImportance;
    private String protocol;
    private String protocolImportance;

    public DispositionOptions(String options) throws OpenAS2Exception {
        this.parseOptions(options);
    }

    public void setMicalg(String micalg) {
        this.micalg = micalg;
    }

    public String getMicalg() {
        return this.micalg;
    }

    public void setMicalgImportance(String micalgImportance) {
        this.micalgImportance = micalgImportance;
    }

    public String getMicalgImportance() {
        return this.micalgImportance;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocolImportance(String protocolImportance) {
        this.protocolImportance = protocolImportance;
    }

    public String getProtocolImportance() {
        return this.protocolImportance;
    }

    public String makeOptions() {
        StringBuffer options = new StringBuffer();
        if (this.getProtocolImportance() == null && this.getProtocol() == null && this.getMicalgImportance() == null && this.getMicalg() == null) {
            return new String("");
        }
        options.append("signed-receipt-protocol=").append(this.getProtocolImportance());
        options.append(", ").append(this.getProtocol());
        options.append("; signed-receipt-micalg=").append(this.getMicalgImportance());
        options.append(", ").append(this.getMicalg());
        return options.toString();
    }

    public void parseOptions(String options) throws OpenAS2Exception {
        this.setProtocolImportance(null);
        this.setProtocol(null);
        this.setMicalgImportance(null);
        this.setMicalg(null);
        if (options != null) {
            try {
                StringTokenizer optionTokens = new StringTokenizer(options, "=,;", false);
                if (optionTokens.countTokens() > 5) {
                    optionTokens.nextToken();
                    this.setProtocolImportance(optionTokens.nextToken().trim());
                    this.setProtocol(optionTokens.nextToken().trim());
                    optionTokens.nextToken();
                    this.setMicalgImportance(optionTokens.nextToken().trim());
                    this.setMicalg(optionTokens.nextToken().trim());
                }
            }
            catch (NoSuchElementException nsee) {
                throw new OpenAS2Exception("Invalid disposition options format: " + options);
            }
        }
    }

    public String toString() {
        return this.makeOptions();
    }
}

