/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;
import org.openas2.message.Message;

public class HTTPUtil {
    public static final String MA_HTTP_REQ_TYPE = "HTTP_REQUEST_TYPE";
    public static final String MA_HTTP_REQ_URL = "HTTP_REQUEST_URL";

    public static String getHTTPResponseMessage(int responseCode) {
        String msg = "Unknown";
        switch (responseCode) {
            case 100: {
                msg = "Continue";
                break;
            }
            case 101: {
                msg = "Switching Protocols";
                break;
            }
            case 200: {
                msg = "OK";
                break;
            }
            case 201: {
                msg = "Created";
                break;
            }
            case 202: {
                msg = "Accepted";
                break;
            }
            case 203: {
                msg = "Non-Authoritative Information";
                break;
            }
            case 204: {
                msg = "No Content";
                break;
            }
            case 205: {
                msg = "Reset Content";
                break;
            }
            case 206: {
                msg = "Partial Content";
                break;
            }
            case 300: {
                msg = "Multiple Choices";
                break;
            }
            case 301: {
                msg = "Moved Permanently";
                break;
            }
            case 302: {
                msg = "Found";
                break;
            }
            case 303: {
                msg = "See Other";
                break;
            }
            case 304: {
                msg = "Not Modified";
                break;
            }
            case 305: {
                msg = "Use Proxy";
                break;
            }
            case 307: {
                msg = "Temporary Redirect";
                break;
            }
            case 400: {
                msg = "Bad Request";
                break;
            }
            case 401: {
                msg = "Unauthorized";
                break;
            }
            case 402: {
                msg = "Payment Required";
                break;
            }
            case 403: {
                msg = "Forbidden";
                break;
            }
            case 404: {
                msg = "Not Found";
                break;
            }
            case 405: {
                msg = "Method Not Allowed";
                break;
            }
            case 406: {
                msg = "Not Acceptable";
                break;
            }
            case 407: {
                msg = "Proxy Authentication Required";
                break;
            }
            case 408: {
                msg = "Request Time-out";
                break;
            }
            case 409: {
                msg = "Conflict";
                break;
            }
            case 410: {
                msg = "Gone";
                break;
            }
            case 411: {
                msg = "Length Required";
                break;
            }
            case 412: {
                msg = "Precondition Failed";
                break;
            }
            case 413: {
                msg = "Request Entity Too Large";
                break;
            }
            case 414: {
                msg = "Request-URI Too Large";
                break;
            }
            case 415: {
                msg = "Unsupported Media Type";
                break;
            }
            case 416: {
                msg = "Requested range not satisfiable";
                break;
            }
            case 417: {
                msg = "Expectation Failed";
                break;
            }
            case 500: {
                msg = "Internal Server Error";
                break;
            }
            case 501: {
                msg = "Not Implemented";
                break;
            }
            case 502: {
                msg = "Bad Gateway";
                break;
            }
            case 503: {
                msg = "Service Unavailable";
                break;
            }
            case 504: {
                msg = "Gateway Time-out";
                break;
            }
            case 505: {
                msg = "HTTP Version not supported";
            }
        }
        return msg;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static byte[] readData(InputStream inStream, OutputStream outStream, Message msg) throws IOException, MessagingException {
        byte[] data = null;
        BufferedInputStream in = new BufferedInputStream(inStream);
        String[] request = HTTPUtil.readRequest(in);
        msg.setAttribute(MA_HTTP_REQ_TYPE, request[0]);
        msg.setAttribute(MA_HTTP_REQ_URL, request[1]);
        msg.setHeaders(new InternetHeaders((InputStream)in));
        DataInputStream dataIn = new DataInputStream(in);
        if (msg.getHeader("Content-Length") != null) {
            int contentSize = Integer.parseInt(msg.getHeader("Content-Length"));
            data = new byte[contentSize];
            dataIn.readFully(data);
            return data;
        }
        String transfer_encoding = msg.getHeader("Transfer-Encoding");
        if (transfer_encoding == null) {
            if (msg.getHeader("Content-Length") != null) return data;
            if (outStream == null) throw new IOException("Content-Length missing");
            HTTPUtil.sendHTTPResponse(outStream, 411, false);
            throw new IOException("Content-Length missing");
        }
        if (!transfer_encoding.replaceAll("\\s+", "").equalsIgnoreCase("chunked")) {
            if (outStream == null) throw new IOException("Transfer-Encoding unimplemented: " + transfer_encoding);
            HTTPUtil.sendHTTPResponse(outStream, 411, false);
            throw new IOException("Transfer-Encoding unimplemented: " + transfer_encoding);
        }
        int length = 0;
        data = null;
        block0: while (true) {
            int blocklen;
            block13: {
                blocklen = 0;
                while (true) {
                    int ch;
                    if ((ch = dataIn.readByte()) == 10) {
                        if (blocklen == 0) {
                            break;
                        }
                        break block13;
                    }
                    if (ch >= 97 && ch <= 102) {
                        ch -= 87;
                    } else if (ch >= 65 && ch <= 70) {
                        ch -= 55;
                    } else {
                        if (ch < 48 || ch > 57) continue;
                        ch -= 48;
                    }
                    blocklen = blocklen * 16 + ch;
                }
                msg.setHeader("Content-Length", new Integer(length).toString());
                return data;
            }
            int newlen = length + blocklen;
            byte[] newdata = new byte[newlen];
            if (length > 0) {
                System.arraycopy(data, 0, newdata, 0, length);
            }
            dataIn.readFully(newdata, length, blocklen);
            data = newdata;
            length = newlen;
            while (true) {
                if (dataIn.readByte() == 10) continue block0;
            }
            break;
        }
    }

    public static String[] readRequest(InputStream in) throws IOException {
        StringTokenizer tokens;
        int tokenCount;
        int byteBuf = in.read();
        StringBuffer strBuf = new StringBuffer();
        while (byteBuf != -1 && byteBuf != 13) {
            strBuf.append((char)byteBuf);
            byteBuf = in.read();
        }
        if (byteBuf != -1) {
            in.read();
        }
        if ((tokenCount = (tokens = new StringTokenizer(strBuf.toString(), " ")).countTokens()) >= 3) {
            String[] requestParts = new String[tokenCount];
            for (int i = 0; i < tokenCount; ++i) {
                requestParts[i] = tokens.nextToken();
            }
            return requestParts;
        }
        if (tokenCount == 2) {
            String[] requestParts = new String[]{tokens.nextToken(), "/", tokens.nextToken()};
            return requestParts;
        }
        throw new IOException("Invalid HTTP Request: Token Count - " + tokenCount + "::: String length - " + strBuf.length() + " ::: String - " + strBuf.toString());
    }

    public static void sendHTTPResponse(OutputStream out, int responseCode, boolean hasData) throws IOException {
        StringBuffer httpResponse = new StringBuffer();
        httpResponse.append(Integer.toString(responseCode)).append(" ");
        httpResponse.append(HTTPUtil.getHTTPResponseMessage(responseCode));
        httpResponse.append("\r\n");
        StringBuffer response = new StringBuffer("HTTP/1.1 ");
        response.append(httpResponse);
        out.write(response.toString().getBytes());
        if (!hasData) {
            out.write("\r\n".getBytes());
            out.write(httpResponse.toString().getBytes());
        }
    }
}

